/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.validation;

import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.UserVerificationException;

public class UserCertificateValidation {
    static MessagesUtil msgUtil = new MessagesUtil(null);

    private UserCertificateValidation() {
    }

    public static void validateCertificate(X509Certificate X509cert, String user_data) throws UserVerificationException {
        if (user_data == null) {
            throw new UserVerificationException(msgUtil.getValue("MSG_UserCertificateValidation_USER_DATA_PARAM_NOT_VALID"));
        }
        String sdn = X509cert.getSubjectDN().getName();
        String idCertificate = UserCertificateValidation.getCertificateIdentificacion(sdn);
        if (idCertificate == null) {
            throw new UserVerificationException(msgUtil.getValue("MSG_UserCertificateValidation_SERIALNUMBER_NOT_VALID"));
        }
        String nroDoc = idCertificate.substring(3);
        if (!nroDoc.equals(user_data)) {
            throw new UserVerificationException(nroDoc + "!=" + user_data);
        }
    }

    private static String getCertificateIdentificacion(String sdn) {
        StringTokenizer stk = new StringTokenizer(sdn, ",");
        String respuesta = null;
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (!token.contains("SERIALNUMBER")) continue;
            String[] partes = token.split("=");
            respuesta = partes[1];
            break;
        }
        return respuesta;
    }
}

