/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import uy.ub.agesic.fd.business.validation.UtilsValidation;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.controllers.DisplayFilesController;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.utils.ShowDocumentSofis;
import uy.ub.agesic.fd.utils.SofisFile;
import uy.ub.agesic.fd.utils.StageUtil;

public class ConfirmacionController
implements Initializable {
    @FXML
    private Button btnVerArchivos;
    @FXML
    private Button btnSalir;
    @FXML
    private Button btnFirmarMas;
    @FXML
    private ListView<SofisFile> listFilesSigned;
    MessagesUtil msgUtil = new MessagesUtil(null);
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    @FXML
    private Text textOtroFirmante;
    @FXML
    private Button btnFirmaOtro;
    @FXML
    private Text textNoFoundImg;

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarLista();
        this.btnFirmarMas.setVisible(false);
        if (this.holder.getRequiereCargarImg().booleanValue()) {
            this.textNoFoundImg.setText(this.msgUtil.getValue("MGS_IMAGEN_NO_FOUND"));
        }
        if (UtilsValidation.isSistemasExternos()) {
            this.btnFirmaOtro.setVisible(false);
            this.btnVerArchivos.setVisible(false);
            if (this.holder.getProceso().getCantidadFirmantes() != null) {
                if (this.holder.getProceso().getCantidadFirmantes() == 0) {
                    this.textOtroFirmante.setText(this.msgUtil.getValue("MGS_OTRO_FIRMANTE"));
                    this.btnFirmarMas.setVisible(true);
                } else if (this.holder.getProceso().getCantidadFirmantes() != 1 && this.holder.getProceso().getCantidadFirmantes() > 1 && this.holder.getProceso().getCatidadFirmasAplicadas() != this.holder.getProceso().getCantidadFirmantes()) {
                    this.textOtroFirmante.setText(this.msgUtil.getValue("MGS_OTRO_FIRMANTE"));
                    this.btnFirmarMas.setVisible(true);
                }
            }
        }
    }

    @FXML
    private void verArchivos(ActionEvent event) throws IOException {
        StageUtil stage = new StageUtil();
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_VIEW_PDF_SIGNED_TITLE"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("MSG_VIEW_PDF_XML_SIGNED"), new String[]{"*.pdf", "*.xml"})});
        chooser.setInitialDirectory(new File(this.holder.getDirectorySignedFiles()));
        List files = chooser.showOpenMultipleDialog((Window)stage.getStage());
        if (files != null) {
            for (File file : files) {
                ShowDocumentSofis.showDocument(file.getAbsolutePath());
            }
        }
    }

    @FXML
    private void pressVerArchivos(KeyEvent event) throws IOException {
        if (event.getCode() == KeyCode.ENTER) {
            this.verArchivos(new ActionEvent());
        }
    }

    @FXML
    private void salir(ActionEvent event) {
        Platform.exit();
        System.exit(0);
    }

    @FXML
    private void pressSalir(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.salir(new ActionEvent());
        }
    }

    @FXML
    private void firmarMas(ActionEvent event) {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
        this.stageHolder.setResizable(true);
        DisplayFilesController dispay = new DisplayFilesController();
        dispay.initialize(this.stageHolder.getStage());
        this.stageHolder.setResizable(false);
    }

    private void cargarLista() {
        ObservableList elements = FXCollections.observableArrayList(this.holder.getSofisFilesSigned());
        this.listFilesSigned.setItems(elements);
        this.listFilesSigned.setStyle("-fx-background-color: #FFF;");
        this.listFilesSigned.setCellFactory(param -> new ListCell<SofisFile>(){
            private ImageView displayImage = new ImageView();

            public void updateItem(SofisFile sf, boolean empty) {
                Image image = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/ok.png"));
                this.displayImage.setImage(image);
                super.updateItem((Object)sf, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    Label labelName = new Label(sf.getNombre());
                    labelName.setMinWidth(Double.NEGATIVE_INFINITY);
                    labelName.setPrefWidth(400.0);
                    HBox hbox = new HBox(new Node[]{labelName, this.displayImage});
                    this.setGraphic((Node)hbox);
                }
            }
        });
    }

    @FXML
    private void firmarOtro(ActionEvent event) throws IOException {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
        this.holder.setSofisFile(null);
        this.holder.setSofisFilesSigned(null);
        this.holder.setProceso(null);
        stage.openDialog((Event)event, "SeleccionDispositivoFirma");
    }

    @FXML
    private void pressFirmaOtro(KeyEvent event) throws IOException {
        if (event.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)event.getSource();
            Stage stageToClose = (Stage)nodeClose.getScene().getWindow();
            stageToClose.close();
            this.holder.setSofisFile(null);
            this.holder.setSofisFilesSigned(null);
            this.holder.setProceso(null);
            StageUtil stage = new StageUtil();
            stage.openDialog((Event)event, "SeleccionDispositivoFirma");
        }
    }
}

