/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import eu.bitwalker.useragentutils.UserAgent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingNode;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.util.PropertiesManager;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.business.services.ClientService;
import uy.ub.agesic.fd.business.validation.UtilsValidation;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.dto.UbicacionFirma;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.icepdf.SofisAnnotationCallback;
import uy.ub.agesic.fd.icepdf.SofisSwingViewBuilder;
import uy.ub.agesic.fd.pdf.PDFBoxSofisUtil;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.OSValidator;
import uy.ub.agesic.fd.utils.SofisFile;
import uy.ub.agesic.fd.utils.StageUtil;

public class DisplayFilesController {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private HashMap<String, String> opciones = null;
    private static final HashMap<String, String> params = new HashMap();
    private List<SofisFile> documents = new ArrayList<SofisFile>();
    private Integer qtyDocument;
    private SofisFile currentFile;
    private String leyenda;
    private Boolean isStart;
    private Stage primaryStage;
    private String uuid;
    MessagesUtil msgUtil = new MessagesUtil(null);
    ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
    private SwingController swingController;
    private JComponent viewerPanel;
    Button btnCopiarUbicaciones = new Button();
    Button btnCancelar = new Button(this.msgUtil.getValue("MSG_BTN_CANCEL"));
    Button btnVolver = new Button(this.msgUtil.getValue("MSG_BTN_BACK"));
    HBox hBox = new HBox();
    private ListView<SofisFile> listViewFiles = new ListView();
    Label lbNameCurrentFile = new Label();
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    public static final String CSS_BTN_SECUNDARY = "    -fx-text-fill: #002e7c;  -fx-font-size: 14; -fx-background-color: #f4f4f4; -fx-border-color: #002e7c;  -fx-border-width: 2px; -fx-padding: 9 20 10 20;  -fx-background-radius: 6px;  -fx-border-radius: 6px;  -fx-cursor: hand;  -fx-font-weight: bold;";

    public void initialize(Stage stage) {
        this.primaryStage = stage;
        this.isStart = this.holder.getSofisFilesSigned() == null;
        String string = this.uuid = StringUtils.isBlank((CharSequence)this.holder.getParemeterIdentifier()) ? this.holder.getUuid() : this.holder.getParemeterIdentifier();
        if (this.inicializarAplicativo()) {
            try {
                this.lbNameCurrentFile.setStyle("-fx-font-size: 17; -fx-background-color: #003da5; -fx-text-fill: white;");
                this.lbNameCurrentFile.setMaxWidth(Double.MAX_VALUE);
                this.lbNameCurrentFile.setText(this.documents.get(0).getNombre());
                BorderPane borderPane = new BorderPane();
                Scene scene = new Scene((Parent)borderPane);
                scene.getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
                scene.setFill((Paint)javafx.scene.paint.Color.TRANSPARENT);
                this.createViewer(borderPane);
                borderPane.setPrefSize((double)StageUtil.WIDTH_VISOR_PDF.intValue(), (double)StageUtil.HEIGHT_VISOR_PDF.intValue());
                this.createResizeListeners(scene, this.viewerPanel);
                stage.setOnCloseRequest(we -> SwingUtilities.invokeLater(() -> this.swingController.dispose()));
                Image icono = new Image(this.getClass().getResourceAsStream("/images/favicon.png"));
                stage.getIcons().add((Object)icono);
                stage.setScene(scene);
                stage.sizeToScene();
                stage.centerOnScreen();
                stage.setResizable(this.stageHolder.isResizable());
                stage.show();
                this.openDocument();
                if (this.isStart.booleanValue()) {
                    String locale = this.cfgUtil.getValue("LOCALE");
                    this.msgUtil.setLocale(locale);
                    this.initOpciones();
                    this.initUserAgent();
                    this.stageHolder.setStage(stage);
                }
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(DisplayFilesController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError(this.msgUtil.getValue("ERROR_INICIO"), this.msgUtil.getValue("ERROR_FILE_FAIL"));
        }
    }

    private void initOpciones() {
        this.opciones = new HashMap();
        if (this.cfgUtil == null) {
            this.cfgUtil = new ConfigurationUtil(null);
        }
        for (String key : this.cfgUtil.keySet()) {
            try {
                String keyValue = this.getParams(key);
                if (keyValue == null) continue;
                this.opciones.put(key, keyValue);
            }
            catch (Exception w) {
                Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, key, w);
            }
        }
        this.cfgUtil = new ConfigurationUtil(this.opciones);
        if (this.msgUtil == null) {
            this.msgUtil = new MessagesUtil(null);
        }
        String locale = this.cfgUtil.getValue("LOCALE");
        this.msgUtil.setLocale(locale);
        for (String key : this.msgUtil.keySet()) {
            try {
                String keyValue = this.getParams(key);
                if (keyValue == null) continue;
                this.opciones.put(key, keyValue);
            }
            catch (Exception w) {
                Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, key, w);
            }
        }
        this.msgUtil = new MessagesUtil(this.opciones);
        this.holder.setCfgUtil(this.cfgUtil);
        this.holder.setOpciones(this.opciones);
        this.holder.setMsgUtil(this.msgUtil);
    }

    public String getParams(String key) {
        return params.get(key);
    }

    private void createResizeListeners(Scene scene, JComponent viewerPanel) {
        scene.widthProperty().addListener((observable, oldValue, newValue) -> SwingUtilities.invokeLater(() -> {
            viewerPanel.setSize(new Dimension(newValue.intValue(), (int)scene.getHeight()));
            viewerPanel.setPreferredSize(new Dimension(newValue.intValue(), (int)scene.getHeight()));
            viewerPanel.repaint();
        }));
        scene.heightProperty().addListener((observable, oldValue, newValue) -> SwingUtilities.invokeLater(() -> {
            viewerPanel.setSize(new Dimension((int)scene.getWidth(), newValue.intValue()));
            viewerPanel.setPreferredSize(new Dimension((int)scene.getWidth(), newValue.intValue()));
            viewerPanel.repaint();
        }));
    }

    private void initUserAgent() {
        this.holder.setUserAgent(this.getBrowserIfo());
        this.holder.setUserHomePath(System.getProperty("user.home"));
    }

    public UserAgent getBrowserIfo() {
        try {
            UserAgent uAgent = new UserAgent("User-agent header sent: Mozilla/5.0 (" + OSValidator.getOSName() + " " + OSValidator.getOSVersion() + "; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0");
            return uAgent;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void openDocument() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DisplayFilesController.this.swingController.openDocument(DisplayFilesController.this.currentFile.getBytes(), 0, DisplayFilesController.this.currentFile.getBytes().length, DisplayFilesController.this.currentFile.getNombre(), null);
                    DisplayFilesController.this.viewerPanel.revalidate();
                    DisplayFilesController.this.bloquearAnotacionesExistentes();
                    DisplayFilesController.this.reaplicarAnotacionesFirma();
                    DisplayFilesController.this.pasarAModoAnotaciones();
                }
                catch (Exception ex) {
                    Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private boolean validarAgregarUbicacion(UbicacionFirma ubNueva) {
        for (UbicacionFirma uf : this.currentFile.getUbicacionesFirma()) {
            if (!uf.equals(ubNueva)) continue;
            return false;
        }
        return true;
    }

    private void actualizarUbicacionesFirma() {
        PageTree pageTree = this.swingController.getDocument().getPageTree();
        for (int pageNum = 0; pageNum < pageTree.getNumberOfPages(); ++pageNum) {
            Page page = pageTree.getPage(pageNum);
            if (page.getAnnotations() == null) continue;
            for (int annotNum = 0; annotNum < page.getAnnotations().size(); ++annotNum) {
                UbicacionFirma ufNueva;
                Rectangle2D.Float annotPos;
                Annotation annot = (Annotation)page.getAnnotations().get(annotNum);
                if (!this.uuid.equals(annot.getEntries().get("PFEA")) || (annotPos = annot.getUserSpaceRectangle()) == null || !this.validarAgregarUbicacion(ufNueva = new UbicacionFirma(pageNum, (int)(annotPos = this.changeForRotation((int)page.getFloat(Page.ROTATE_KEY), annotPos, page)).getX(), (int)annotPos.getY(), (int)annotPos.getWidth(), (int)annotPos.getHeight()))) continue;
                this.currentFile.getUbicacionesFirma().add(ufNueva);
            }
        }
    }

    private void bloquearAnotacionesExistentes() {
        BorderStyle borderStyle = new BorderStyle();
        borderStyle.setStrokeWidth(3.0f);
        borderStyle.setBorderStyle(BorderStyle.BORDER_STYLE_SOLID);
        PageTree pageTree = this.swingController.getDocument().getPageTree();
        for (int pageNum = 0; pageNum < pageTree.getNumberOfPages(); ++pageNum) {
            Page page = pageTree.getPage(pageNum);
            if (page.getAnnotations() == null) continue;
            for (int annotNum = 0; annotNum < page.getAnnotations().size(); ++annotNum) {
                Annotation annot = (Annotation)page.getAnnotations().get(annotNum);
                if (this.uuid.equals(annot.getEntries().get("PFEA"))) continue;
                annot.setFlag(128, true);
            }
        }
    }

    private void reaplicarAnotacionesFirma() {
        List<UbicacionFirma> ubicsFirmaDoc = this.currentFile.getUbicacionesFirma();
        if (ubicsFirmaDoc != null && !ubicsFirmaDoc.isEmpty()) {
            BorderStyle borderStyle = new BorderStyle();
            borderStyle.setStrokeWidth(3.0f);
            borderStyle.setBorderStyle(BorderStyle.BORDER_STYLE_SOLID);
            Library library = this.swingController.getDocument().getPageTree().getLibrary();
            DocumentViewModel docViewModel = this.swingController.getDocumentViewController().getDocumentViewModel();
            List pageComponents = docViewModel.getPageComponents();
            for (UbicacionFirma ubicFirmaDoc : ubicsFirmaDoc) {
                if (ubicFirmaDoc.getPagina() >= pageComponents.size()) continue;
                Rectangle tBbox = new Rectangle(ubicFirmaDoc.getPosX(), ubicFirmaDoc.getPosY(), ubicFirmaDoc.getWidth(), ubicFirmaDoc.getHeight());
                SquareAnnotation sqAnnot = (SquareAnnotation)AnnotationFactory.buildAnnotation((Library)library, (Name)Annotation.SUBTYPE_SQUARE, (Rectangle)tBbox);
                sqAnnot.setColor(Color.BLUE);
                sqAnnot.setBorderStyle(borderStyle);
                sqAnnot.setBBox(new Rectangle(0, 0, tBbox.width, tBbox.height));
                sqAnnot.resetAppearanceStream(0.0, 0.0, null);
                AbstractAnnotationComponent annotComp = AnnotationComponentFactory.buildAnnotationComponent((Annotation)sqAnnot, (DocumentViewController)this.swingController.getDocumentViewController(), (AbstractPageViewComponent)((AbstractPageViewComponent)pageComponents.get(ubicFirmaDoc.getPagina())), (DocumentViewModel)docViewModel);
                this.swingController.getDocumentViewController().getAnnotationCallback().newAnnotation((PageViewComponent)pageComponents.get(ubicFirmaDoc.getPagina()), (AnnotationComponent)annotComp);
            }
        }
    }

    private void pasarAModoAnotaciones() {
        this.swingController.getDocumentViewController().getParentController().setDocumentToolMode(6);
        List<UbicacionFirma> ubicsFirmaDoc = this.currentFile.getUbicacionesFirma();
        if (ubicsFirmaDoc == null || ubicsFirmaDoc.isEmpty()) {
            JToggleButton tButton2 = (JToggleButton)this.buscarComponente((Container)this.viewerPanel.getComponent(1), "btnSquareAnnotationTool");
            if (tButton2 != null) {
                tButton2.doClick();
            }
        } else {
            this.currentFile.getUbicacionesFirma().clear();
        }
    }

    private Component buscarComponente(Container c, String nombre) {
        if (c == null) {
            return null;
        }
        if (nombre.equals(c.getName())) {
            return c;
        }
        if (c.getComponentCount() > 0) {
            for (Component c1 : c.getComponents()) {
                Component c2;
                if (!(c1 instanceof Container) || (c2 = this.buscarComponente((Container)c1, nombre)) == null) continue;
                return c2;
            }
        }
        return null;
    }

    private boolean inicializarAplicativo() {
        try {
            if (!this.isStart.booleanValue()) {
                this.holder.setSofisFile(this.holder.getSofisFilesSigned());
                this.documents = this.holder.getSofisFile();
            } else {
                if (!StringUtils.isBlank((CharSequence)this.holder.getParemeterIdentifier())) {
                    ClientService service = new ClientService();
                    service.consultaProceso(this.holder.getParemeterIdentifier(), this.holder.getParemeterPassword());
                    this.holder.getProceso().setCatidadFirmasAplicadas(0);
                }
                if (!this.holder.getSofisFile().isEmpty()) {
                    this.documents = this.holder.getSofisFile();
                }
            }
            if (!this.documents.isEmpty()) {
                this.setQtyDocument(this.documents.size());
                this.currentFile = this.documents.get(0);
                return true;
            }
            this.setQtyDocument(0);
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private void createViewer(BorderPane borderPane) throws InvocationTargetException {
        this.swingController = new SwingController();
        this.swingController.setIsEmbeddedComponent(true);
        PropertiesManager properties = new PropertiesManager(System.getProperties(), ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        properties.set("application.toolbar.show.utility.upane", "true");
        properties.set("application.toolbar.show.fit", "true");
        properties.set("application.statusbar", "false");
        properties.set("application.zoom.factor.default", "1.50");
        properties.set("application.toolbar.show.utility.open", "false");
        properties.set("application.toolbar.show.utility.save", "false");
        properties.set("application.toolbar.show.utility.print", "false");
        properties.set("application.toolbar.show.utility.search", "false");
        properties.set("application.toolbar.show.rotate", "false");
        properties.set("application.toolbar.show.annotation", "false");
        properties.set("application.toolbar.show.forms", "false");
        properties.set("application.toolbar.show.zoom", "true");
        properties.set("application.toolbar.show.tool", "false");
        properties.set("application.utilitypane.show.signatures", "false");
        properties.set("application.utilitypane.show.search", "false");
        properties.set("application.utilitypane.show.thumbs", "false");
        properties.set("application.utilitypane.show.layers", "false");
        properties.set("application.utilitypane.show.bookmarks", "false");
        properties.set("application.utilitypane.show.attachments", "false");
        properties.set("application.toolbar.annotation.show.arrow", "false");
        properties.set("application.toolbar.annotation.show.circle", "false");
        properties.set("application.toolbar.annotation.show.freeText", "false");
        properties.set("application.toolbar.annotation.show.highlight", "false");
        properties.set("application.toolbar.annotation.show.ink", "false");
        properties.set("application.toolbar.annotation.show.line", "false");
        properties.set("application.toolbar.annotation.show.link", "false");
        properties.set("application.toolbar.annotation.show.strikeOut", "false");
        properties.set("application.toolbar.annotation.show.text", "false");
        properties.set("application.toolbar.annotation.show.underline", "false");
        properties.set("application.utilitypane.show.annotation.flags", "false");
        properties.set("application.toolbar.show.annotation.selection", "true");
        properties.set("application.toolbar.show.annotation.highlight", "false");
        properties.set("application.toolbar.show.annotation.text", "false");
        this.swingController.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new SofisAnnotationCallback(this.swingController.getDocumentViewController(), this.uuid, false));
        SofisSwingViewBuilder builder = new SofisSwingViewBuilder(this.swingController, properties);
        this.viewerPanel = builder.buildViewerPanel();
        this.viewerPanel.revalidate();
        SwingNode swingNode = new SwingNode();
        swingNode.setContent(this.viewerPanel);
        swingNode.setFocusTraversable(false);
        Separator separator = new Separator(Orientation.HORIZONTAL);
        VBox vBoxTop = new VBox();
        Label lblUbicarFirma = new Label();
        lblUbicarFirma.setStyle("-fx-text-fill: black; -fx-font-size:25; -fx-font-weight: bold; ");
        lblUbicarFirma.setText(this.msgUtil.getValue("MSG_UBICAR_FIRMA"));
        vBoxTop.setAlignment(Pos.CENTER_LEFT);
        vBoxTop.setStyle("-fx-padding: 35 0 20 25;");
        vBoxTop.getChildren().addAll((Object[])new Node[]{lblUbicarFirma});
        this.btnCopiarUbicaciones = new Button(this.msgUtil.getValue("MSG_BTN_COPIAR_UBICACIONES"));
        this.btnCopiarUbicaciones.getStyleClass().add((Object)"btn-secondary");
        Button btnContinuar = new Button(UtilsValidation.isSistemasExternos() ? this.msgUtil.getValue("MSG_BTN_CONTINUE") : this.msgUtil.getValue("MSG_BTN_CONTINUE2"));
        btnContinuar.getStyleClass().add((Object)"btn-primary");
        this.btnCancelar.getStyleClass().add((Object)"btn-secondary");
        this.btnVolver.getStyleClass().add((Object)"btn-secondary");
        if (UtilsValidation.isSistemasExternos()) {
            this.btnVolver.setVisible(false);
        }
        this.btnCopiarUbicaciones.setOnAction(event -> this.copiarUbicaciones());
        this.btnCopiarUbicaciones.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.copiarUbicaciones();
            }
        });
        btnContinuar.setOnAction(event -> {
            try {
                this.continuar(event);
            }
            catch (IOException ex) {
                Logger.getLogger(DisplayFilesController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        btnContinuar.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                try {
                    this.continuar(event);
                }
                catch (IOException ex) {
                    Logger.getLogger(DisplayFilesController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnCancelar.setOnAction(event -> System.exit(0));
        this.btnCancelar.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                System.exit(0);
            }
        });
        this.btnVolver.setOnAction(event -> this.volver(event));
        this.btnVolver.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.volver(event);
            }
        });
        VBox vBoxButton = new VBox();
        vBoxButton.setPadding(new Insets(5.0));
        vBoxButton.setAlignment(Pos.CENTER);
        this.hBox = new HBox();
        this.hBox.setStyle("-fx-background-color: #F7F8F9; -fx-padding: 10 0 11 0;");
        if (this.qtyDocument > 1) {
            this.hBox.getChildren().addAll((Object[])new Node[]{this.btnCopiarUbicaciones});
            this.hBox.setSpacing(10.0);
            this.hBox.setPadding(new Insets(5.0));
            this.hBox.setAlignment(Pos.TOP_CENTER);
            vBoxButton.getChildren().add((Object)this.hBox);
            vBoxButton.getChildren().add((Object)separator);
        }
        ImageView imageViewLogo = new ImageView();
        BorderPane toolBorderPane = new BorderPane();
        HBox hBoxToolBarRight = new HBox();
        hBoxToolBarRight.getChildren().addAll((Object[])new Node[]{this.btnVolver, btnContinuar});
        hBoxToolBarRight.setSpacing(10.0);
        Image imageLogo = new Image(this.getClass().getResourceAsStream("/images/agesic-color.png"));
        imageViewLogo.setImage(imageLogo);
        imageViewLogo.setFitWidth(200.0);
        imageViewLogo.setPreserveRatio(true);
        HBox hBoxToolBarLeft = new HBox();
        hBoxToolBarLeft.setSpacing(30.0);
        hBoxToolBarLeft.getChildren().addAll((Object[])new Node[]{imageViewLogo, this.btnCancelar});
        toolBorderPane.setLeft((Node)hBoxToolBarLeft);
        toolBorderPane.setRight((Node)hBoxToolBarRight);
        toolBorderPane.setStyle(" -fx-background-color: #FFFFFF; -fx-padding: 10 20 5 20;");
        vBoxButton.getChildren().add((Object)toolBorderPane);
        ImageView imageView = new ImageView();
        BorderPane borderPaneCenter = new BorderPane();
        HBox hBoxLogoNameFile = new HBox();
        Image imgPDF = new Image(this.getClass().getResourceAsStream("/images/pdf-2.png"));
        imageView.setImage(imgPDF);
        StackPane stackPaneforImageActivity = new StackPane();
        stackPaneforImageActivity.setAlignment(Pos.CENTER);
        stackPaneforImageActivity.getChildren().add((Object)imageView);
        stackPaneforImageActivity.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        imageView.setStyle("-fx-padding: 30 30 30 15;");
        hBoxLogoNameFile.setStyle("-fx-padding: 15 3 15 1; -fx-background-color: #003da5;");
        hBoxLogoNameFile.getChildren().addAll((Object[])new Node[]{stackPaneforImageActivity, this.lbNameCurrentFile});
        borderPaneCenter.setTop((Node)hBoxLogoNameFile);
        borderPaneCenter.setCenter((Node)swingNode);
        borderPane.setStyle(" -fx-background-color: #fff; -fx-padding: 0 5 5 0;");
        this.cargarLista();
        Label titleFileUpload = new Label("Archivos cargados");
        titleFileUpload.setStyle(" -fx-font-weight: bold;  -fx-padding: 5 5 5 5; ");
        VBox vBoxLeft = new VBox();
        vBoxLeft.setStyle(" -fx-background-color: #FFFFFF; -fx-padding: 20 20 5 20; ");
        vBoxLeft.getChildren().addAll((Object[])new Node[]{titleFileUpload, this.listViewFiles});
        borderPaneCenter.setFocusTraversable(false);
        borderPane.setTop((Node)vBoxTop);
        borderPane.setBottom((Node)vBoxButton);
        borderPane.setCenter((Node)borderPaneCenter);
        borderPane.setLeft((Node)vBoxLeft);
    }

    private void continuar(Event event) throws IOException {
        this.actualizarUbicacionesFirma();
        try {
            StageUtil stage = new StageUtil();
            ArrayList<Integer> docsSinFirma = new ArrayList<Integer>();
            for (int docNum = 0; docNum < this.documents.size(); ++docNum) {
                if (this.holder.getSofisFile().get(docNum).getUbicacionesFirma() != null && !this.holder.getSofisFile().get(docNum).getUbicacionesFirma().isEmpty()) continue;
                docsSinFirma.add(docNum + 1);
            }
            if (!docsSinFirma.isEmpty()) {
                String mensaje = this.msgUtil.getValue(docsSinFirma.size() == 1 ? "MSG_DOCUMENTO_X_SIN_FIRMA_DEFINIDA" : "MSG_DOCUMENTOS_X_SIN_FIRMA_DEFINIDA").replace("{numero_doc}", "" + ((Object)docsSinFirma).toString());
                AlertasUtil alerta = new AlertasUtil();
                boolean continuar = alerta.displayAlertYesNo(this.msgUtil.getValue("MSG_DOCUMENTOS_SIN_FIRMA_DEFINIDA"), mensaje);
                if (!continuar) {
                    return;
                }
            }
            if (!UtilsValidation.isSistemasExternos()) {
                File selectedDirectory;
                DirectoryChooser directoryChooser = new DirectoryChooser();
                directoryChooser.setTitle(this.msgUtil.getValue("MSG_SELECTED_DIRECTORY"));
                if (this.documents != null && !this.documents.isEmpty() && this.documents.get(0).getPath() != null) {
                    File initialDirectory = new File(this.documents.get(0).getPath());
                    directoryChooser.setInitialDirectory(new File(initialDirectory.getParent()));
                }
                if ((selectedDirectory = directoryChooser.showDialog((Window)stage.getStage())) != null) {
                    this.holder.setDirectorySignedFiles(selectedDirectory.getAbsolutePath() + File.separator);
                }
                if (StringUtils.isBlank((CharSequence)this.holder.getDirectorySignedFiles())) {
                    AlertasUtil alerta = new AlertasUtil();
                    alerta.displayAlertError(this.msgUtil.getValue("MSG_VALIDATION"), this.msgUtil.getValue("MSG_NO_SELECTED_DIRECTORY"));
                    return;
                }
            }
            if (this.holder.getProceso().getMetodoFirma() != null) {
                stage.openShowAndWait(event, "Firmar");
            } else {
                stage.openShowAndWait(event, "SeleccionarDispositivo");
            }
        }
        catch (Exception ex) {
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    private void volver(Event event) {
        try {
            this.holder.setSofisFile(null);
            StageUtil stageUtil = new StageUtil();
            stageUtil.close(event);
            stageUtil.open(event, "DragAndDrop");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "volver::: ", e);
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    private void copiarUbicaciones() {
        AlertasUtil alerta = new AlertasUtil();
        boolean copiar = alerta.displayAlertYesNo(this.msgUtil.getValue("MSG_DOCUMENTOS_SIN_FIRMA_DEFINIDA"), this.msgUtil.getValue("MSG_CONFIRMAR_COPIA_UBICACIONES"));
        if (!copiar) {
            return;
        }
        this.actualizarUbicacionesFirma();
        try {
            for (SofisFile sFile : this.holder.getSofisFile()) {
                if (sFile.getIdentificadorFile().equals(this.currentFile.getIdentificadorFile())) continue;
                sFile.getUbicacionesFirma().clear();
                for (UbicacionFirma uFirma : this.currentFile.getUbicacionesFirma()) {
                    sFile.getUbicacionesFirma().add(new UbicacionFirma(this.validateNumberPage(uFirma.getPagina(), PDFBoxSofisUtil.numeroPaginasDeDocumento(sFile.getBytes()) - 1), uFirma.getPosX(), uFirma.getPosY(), uFirma.getWidth(), uFirma.getHeight()));
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, DisplayFilesController.class.getName(), ex);
        }
    }

    private int validateNumberPage(int pagToAssing, int pagMaxFile) {
        return pagToAssing > pagMaxFile ? pagMaxFile : pagToAssing;
    }

    private void cargarLista() {
        this.listViewFiles = new ListView();
        ObservableList elements = FXCollections.observableArrayList(this.holder.getSofisFile());
        this.listViewFiles.setItems(elements);
        this.listViewFiles.setStyle("-fx-background-color: #FFF;");
        this.listViewFiles.setPrefHeight(600.0);
        this.listViewFiles.setFocusTraversable(false);
        this.listViewFiles.setCellFactory(param -> new ListCell<SofisFile>(){
            private ImageView imageAncla = new ImageView();
            private ImageView imagePDF = new ImageView();

            public void updateItem(SofisFile sf, boolean empty) {
                super.updateItem((Object)sf, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    if (this.isHover()) {
                        this.imagePDF.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/pdf-2.png")));
                        this.imageAncla.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream(sf.getUbicacionesFirma().isEmpty() ? "/images/pin-white.png" : "/images/pin-black.png")));
                    } else {
                        this.imagePDF.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/pdf.png")));
                        this.imageAncla.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream(sf.getUbicacionesFirma().isEmpty() ? "/images/pin-gray.png" : "/images/pin-black.png")));
                    }
                    Label labelName = new Label(sf.getNombre());
                    labelName.setMinWidth(Double.NEGATIVE_INFINITY);
                    labelName.setPrefWidth(175.0);
                    HBox hbox = new HBox(new Node[]{this.imagePDF, labelName, this.imageAncla});
                    this.setGraphic((Node)hbox);
                }
            }
        });
        this.listViewFiles.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<SofisFile>(){

            public void changed(ObservableValue<? extends SofisFile> observable, SofisFile oldValue, SofisFile newValue) {
                DisplayFilesController.this.actualizarUbicacionesFirma();
                DisplayFilesController.this.currentFile = newValue;
                DisplayFilesController.this.lbNameCurrentFile.setText(DisplayFilesController.this.currentFile.getNombre());
                DisplayFilesController.this.openDocument();
                DisplayFilesController.this.listViewFiles.refresh();
            }
        });
    }

    private Rectangle2D.Float changeForRotation(int rotation, Rectangle2D.Float annotPos, Page page) {
        Rectangle2D.Float rect = annotPos;
        switch (rotation) {
            case 0: {
                logger.log(Level.INFO, "P\u00e1gina tiene una rotaci\u00f3n de 0\u00b0");
                return annotPos;
            }
            case 90: {
                logger.log(Level.INFO, "P\u00e1gina tiene una rotaci\u00f3n de 90\u00b0");
                Float y = Float.valueOf((float)(page.getSize(page.getFloat(Page.ROTATE_KEY)).getWidth() - (double)annotPos.x) - annotPos.width);
                y = Float.valueOf(y.floatValue() < 0.0f ? 1.0f : y.floatValue());
                return new Rectangle2D.Float(annotPos.y, y.floatValue(), annotPos.height, annotPos.width);
            }
            case 180: {
                logger.log(Level.INFO, "P\u00e1gina tiene una rotaci\u00f3n de 180\u00b0");
                Float x = Float.valueOf((float)(page.getSize(page.getFloat(Page.ROTATE_KEY)).getWidth() - (double)annotPos.x) - annotPos.width);
                Float y = Float.valueOf((float)(page.getSize(page.getFloat(Page.ROTATE_KEY)).getHeight() - (double)annotPos.y) - annotPos.width);
                y = Float.valueOf(y.floatValue() < 0.0f ? 1.0f : y.floatValue());
                x = Float.valueOf(x.floatValue() < 0.0f ? 1.0f : x.floatValue());
                return new Rectangle2D.Float(x.floatValue(), y.floatValue(), annotPos.height, annotPos.width);
            }
            case 270: {
                logger.log(Level.INFO, "P\u00e1gina tiene una rotaci\u00f3n de 270\u00b0");
                Float x = Float.valueOf((float)(page.getSize(page.getFloat(Page.ROTATE_KEY)).getHeight() - (double)annotPos.y) - annotPos.height);
                x = Float.valueOf(x.floatValue() < 0.0f ? 1.0f : x.floatValue());
                return new Rectangle2D.Float(x.floatValue(), annotPos.x, annotPos.height, annotPos.width);
            }
        }
        logger.log(Level.INFO, "P\u00e1gina tiene una rotaci\u00f3n no permitida {0} ", rotation);
        return annotPos;
    }

    public List<SofisFile> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<SofisFile> documents) {
        this.documents = documents;
    }

    public Integer getQtyDocument() {
        return this.qtyDocument;
    }

    public void setQtyDocument(Integer qtyDocument) {
        this.qtyDocument = qtyDocument;
    }

    public SofisFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(SofisFile currentFile) {
        this.currentFile = currentFile;
    }
}

