/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.business.services.ClientService;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.store.StoreManagment;
import uy.ub.agesic.fd.store.pkcs11.PKCS11CertStoreImpl;
import uy.ub.agesic.fd.store.pkcs11.PKCS11Util;
import uy.ub.agesic.fd.store.pkcs11.VerifyToken;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.StageUtil;

public class FirmarController
implements Initializable {
    MessagesUtil msgUtil = new MessagesUtil(null);
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private final StoreManagment storeMg = new StoreManagment();
    private final ConfigurationUtil cfgUtil;
    AlertasUtil alerta = new AlertasUtil();
    private StageHolder stageHolder = StageHolder.getInstance();
    @FXML
    private TextField txtFile;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private Button btnSelectFile;
    @FXML
    private Button btnCancelar;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private ComboBox cboCertificados = new ComboBox();
    @FXML
    private Button btnFirmar;
    @FXML
    private Label lblFile;
    @FXML
    private Label lblContrasenia;
    @FXML
    private Label lblCertificado;
    @FXML
    private AnchorPane anchorPane1;
    @FXML
    private Button btnCambiarMetodo;

    public FirmarController() {
        this.cfgUtil = this.holder.getCfgUtil();
        this.msgUtil = this.holder.getMsgUtil();
        this.initStoreManagment();
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.determinarDispositivosDisponibles();
        if (this.cboCertificados.getItems().isEmpty()) {
            this.cboCertificados.setVisible(false);
            this.lblCertificado.setVisible(false);
        }
        if (!this.holder.getProceso().getMetodoFirma().equals((Object)MetodoFirmaEnum.P12)) {
            this.txtFile.setVisible(false);
            this.lblFile.setVisible(false);
            this.btnSelectFile.setVisible(false);
        } else {
            this.txtFile.setVisible(true);
            this.lblFile.setVisible(true);
            this.btnSelectFile.setVisible(true);
        }
    }

    @FXML
    private void handlerCambiarMetodo(ActionEvent event) {
        try {
            StageUtil stage = new StageUtil();
            stage.close((Event)event);
            stage.openDialog((Event)event, "SeleccionarDispositivo");
        }
        catch (Exception e) {
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    @FXML
    private void pressCambiarMetodo(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            try {
                Node nodeClose = (Node)event.getSource();
                Stage stageToClose = (Stage)nodeClose.getScene().getWindow();
                stageToClose.close();
                StageUtil stage = new StageUtil();
                stage.openDialog((Event)event, "SeleccionarDispositivo");
            }
            catch (IOException e) {
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
            }
        }
    }

    @FXML
    private void handerCancelar(ActionEvent event) {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
    }

    @FXML
    private void pressCancel(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)event.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void handlerFileChooser(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        Stage stage = new Stage();
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            this.txtFile.setText(file.getAbsolutePath());
        }
    }

    @FXML
    private void handlerFirmar(ActionEvent event) throws IOException, InterruptedException {
        this.cargarCertificados(event, null);
    }

    @FXML
    private void pressFirmar(KeyEvent event) throws IOException, InterruptedException {
        if (event.getCode() == KeyCode.ENTER) {
            this.cargarCertificados(null, event);
        }
    }

    private int determinarDispositivosDisponibles() {
        VerifyToken verify = new VerifyToken();
        int cantDispositivos = 0;
        String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CEDULA").split(";");
        int[] tokens = verify.verificarTokens(dispositivos);
        int tokensConectados = tokens[1];
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_ABITAB").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensConectados = tokens[1];
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CORREO").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensConectados = tokens[1];
        return cantDispositivos += tokensConectados;
    }

    private void cargarCertificados(ActionEvent event, KeyEvent ke) {
        try {
            if (!this.holder.getProceso().getMetodoFirma().equals((Object)MetodoFirmaEnum.P12)) {
                if (StringUtils.isBlank((CharSequence)this.txtPassword.getText())) {
                    this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_CONTRASENIA_EMPTY"));
                    return;
                }
            } else if (StringUtils.isBlank((CharSequence)this.txtFile.getText()) || StringUtils.isBlank((CharSequence)this.txtPassword.getText())) {
                this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_VALIDATION_REQUIRED") + " Archivo/Constrase\u00f1a");
                return;
            }
            this.holder.getProceso().setPassword(this.txtPassword.getText());
            this.holder.getProceso().setPath(this.txtFile.getText());
            this.cboCertificados.getItems().clear();
            this.cboCertificados.setVisible(false);
            this.lblCertificado.setVisible(false);
            List<SofisCertificate> certs = null;
            try {
                String passwordCertStore = null;
                if (this.holder.getProceso().getPassword() != null) {
                    passwordCertStore = this.holder.getProceso().getPassword();
                }
                if (!this.holder.getProceso().getMetodoFirma().equals((Object)MetodoFirmaEnum.P12)) {
                    certs = this.storeMg.getSignCertificateFromPKCS11(passwordCertStore, null, PKCS11CertStoreImpl.PKCS11CertStoreType.ETOKEN, "");
                } else {
                    File f;
                    String file = this.holder.getProceso().getPath();
                    if (file != null && file.length() > 0 && (f = new File(file)).exists()) {
                        certs = this.storeMg.getSignCertificateFromPKCS11(passwordCertStore, this.holder.getProceso().getPath(), PKCS11CertStoreImpl.PKCS11CertStoreType.FILE, "");
                    }
                }
                if (!this.storeMg.isPKCS11_TOKEN_DETECTED() && passwordCertStore.trim().length() > 0) {
                    this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_INGRESO_PASSWORD_INVALIDO"));
                }
            }
            catch (StoreInvalidPasswordException e) {
                logger.log(Level.SEVERE, "", e);
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_CONTRASENIA_INVALIDA"));
                this.switchFirmar(false);
                return;
            }
            catch (DriverException ex) {
                logger.log(Level.SEVERE, "DriverException ", ex);
                this.displayPopupEtokenModel();
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("X_DEVICE_TOKEN_CONNECT"));
                this.switchFirmar(false);
                return;
            }
            for (SofisCertificate cert : certs) {
                if (!cert.isOk()) continue;
                this.cboCertificados.getItems().add((Object)cert);
            }
            this.holder.setCertificates((List<SofisCertificate>)this.cboCertificados.getItems());
            if (this.cboCertificados.getItems().isEmpty()) {
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_EMPTY_CERTIFICADOS"));
                this.switchFirmar(false);
                return;
            }
            ClientService service = new ClientService();
            if (this.cboCertificados.getItems().size() == 1) {
                this.cboCertificados.setVisible(false);
                this.cboCertificados.setDisable(true);
                String firmar = this.cfgUtil.getValue("SIGN_IF_ONLY_ONE_CERTIFICATE_FOUND");
                if (BooleanUtils.toBoolean((String)firmar)) {
                    this.holder.setCertificateSeleceted(this.holder.getCertificates().get(0));
                    service.firmar(event, ke);
                    this.btnSelectFile.setDisable(true);
                    this.btnFirmar.setDisable(true);
                    this.btnCancelar.setDisable(true);
                }
            } else {
                this.cboCertificados.setVisible(true);
                this.cboCertificados.setDisable(false);
                this.switchFirmar(true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception ", e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_APLICATION"), this.msgUtil.getValue("MSG_APLICATION_DES"));
        }
    }

    private void switchFirmar(boolean habilitado) {
        if (habilitado) {
            // empty if block
        }
    }

    private void initStoreManagment() {
        String stores = this.cfgUtil.getValue("STORE");
        StringTokenizer st = new StringTokenizer(stores, ";");
        while (st.hasMoreTokens()) {
            String store = st.nextToken();
            try {
                StoreManagment.store_types type = StoreManagment.store_types.valueOf(store);
                switch (type) {
                    case PKCS11: {
                        PKCS11CertStoreImpl tokenStore = new PKCS11CertStoreImpl(PKCS11CertStoreImpl.PKCS11CertStoreType.ETOKEN, this.holder.getUserAgent(), null);
                        this.storeMg.addCertStore(tokenStore);
                        break;
                    }
                    case PKCS12: {
                        PKCS11CertStoreImpl fileStore = new PKCS11CertStoreImpl(PKCS11CertStoreImpl.PKCS11CertStoreType.FILE, this.holder.getUserAgent(), null);
                        this.storeMg.addCertStore(fileStore);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Exception ", ex);
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), "initStoreManagment() ---> store no soportado");
            }
        }
    }

    public void displayPopupEtokenModel() {
        PKCS11Util util = new PKCS11Util(this.cfgUtil, this.msgUtil);
        String ligAladdin = util.loadETokenLib("Aladdin", this.holder.getUserAgent());
        ligAladdin = ligAladdin != null && ligAladdin.length() != 0 ? " (" + ligAladdin + ")" : "";
        String ligEPass2003 = util.loadETokenLib("ePass2003", this.holder.getUserAgent());
        ligEPass2003 = ligEPass2003 != null && ligEPass2003.length() != 0 ? " (" + ligEPass2003 + ")" : "";
        String ligEPass3003auto = util.loadETokenLib("ePass3003Auto", this.holder.getUserAgent());
        ligEPass3003auto = ligEPass3003auto != null && ligEPass3003auto.length() != 0 ? " (" + ligEPass3003auto + ")" : "";
        String ligGemalto = util.loadETokenLib("Gemalto", this.holder.getUserAgent());
        ligGemalto = ligGemalto != null && ligGemalto.length() != 0 ? " (" + ligGemalto + ")" : "";
        String ligAbitab = util.loadETokenLib("ACSCryptoMate", this.holder.getUserAgent());
        ligAbitab = ligAbitab != null && ligAbitab.length() != 0 ? " (" + ligAbitab + ")" : "";
        String empty = "---------";
        Object[] models = new Object[]{empty, "Aladdin" + ligAladdin, "ePass2003" + ligEPass2003, "ePass3003Auto" + ligEPass3003auto, "C\u00e9dula de Identidad Electr\u00f3nica" + ligGemalto, "Token de Abitab" + ligAbitab, "Otro"};
    }
}

