/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.browser;

import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.DefaultPassStoreKS;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.mscapi.MSCAPIStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.store.CertStoreI;
import uy.ub.agesic.fd.store.SofisCertificate;

public class IECertStoreImpl
implements CertStoreI {
    MSCAPIStore bstore = null;

    private static String getCertificateIdentificacion(String sdn) {
        StringTokenizer stk = new StringTokenizer(sdn, ",");
        String respuesta = null;
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (!token.contains("SERIALNUMBER")) continue;
            String[] partes = token.split("=");
            respuesta = partes[1];
            break;
        }
        return respuesta;
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore() throws StoreException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        try {
            this.bstore = new MSCAPIStore((IPassStoreKS)new DefaultPassStoreKS());
            List lista = this.bstore.getSignCertificates();
            String cn = null;
            int pos = 0;
            for (X509Certificate c : lista) {
                cn = IECertStoreImpl.getCertificateIdentificacion(c.getSubjectDN().getName());
                if (cn == null) {
                    try {
                        String[] aux;
                        for (String n : aux = c.getSubjectDN().getName().split(",")) {
                            if (!n.trim().toLowerCase().contains("cn=")) continue;
                            cn = n.trim().split("=")[1];
                            break;
                        }
                    }
                    catch (Exception w) {
                        cn = c.getSubjectDN().getName();
                    }
                }
                SofisCertificate cert = new SofisCertificate(cn, pos, c, (CertStoreI)this);
                toReturn.add(cert);
                ++pos;
            }
            return toReturn;
        }
        catch (CertStoreException ex) {
            throw new StoreException(ex);
        }
    }

    @Override
    public PrivateKey getPrivateKey(SofisCertificate certificate, String certificatePass) throws StoreException {
        try {
            return this.bstore.getPrivateKey(certificate.getCertificate());
        }
        catch (CertStoreException ex) {
            throw new StoreException(ex);
        }
    }

    @Override
    public Provider getProvider(SofisCertificate certificate) {
        return null;
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore(String activeProvider) throws StoreException, DriverException, StoreInvalidPasswordException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

