/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.utils;

import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Window;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.utils.StageUtil;

public class AlertasUtil {
    MessagesUtil msgUtil = new MessagesUtil(null);
    private final ProcesoHolder holder = ProcesoHolder.getInstance();
    private final StageHolder stageHolder = StageHolder.getInstance();
    private final String MSG_ALERT_TITLE = this.msgUtil.getValue("MSG_ALERT_TITLE");
    private final String MSG_ALERT_HEADER_CONFIRM = this.msgUtil.getValue("MSG_ALERT_HEADER_CONFIRM");
    private final String styleCSSPath = "/css/style.css";
    private final String alertaClase = "alerta";

    @FXML
    public void displayAlertError(String header, String msj) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("");
        alert.getDialogPane().getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        alert.getDialogPane().getStyleClass().add((Object)"alerta");
        alert.setHeaderText(header);
        alert.setResizable(true);
        alert.getDialogPane().setPrefSize((double)StageUtil.WIDTH_ALERT.intValue(), (double)StageUtil.HEIGHT_ALERT.intValue());
        alert.setContentText(msj);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)this.stageHolder.getStage());
        alert.showAndWait();
    }

    @FXML
    public void displayAlertWarning(String msj) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("");
        alert.getDialogPane().getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        alert.getDialogPane().getStyleClass().add((Object)"alerta");
        alert.getDialogPane().setPrefSize((double)StageUtil.WIDTH_ALERT.intValue(), (double)StageUtil.HEIGHT_ALERT.intValue());
        alert.setHeaderText(this.msgUtil.getValue("MSG_ALERT_HEADER_WARNING"));
        alert.setContentText(msj);
        alert.setResizable(true);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)this.stageHolder.getStage());
        alert.showAndWait();
    }

    @FXML
    public boolean displayAlertYesNo(String header, String msj) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(this.msgUtil.getValue("MSG_ALERT_HEADER_CONFIRM"));
        alert.getDialogPane().getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        alert.getDialogPane().getStyleClass().add((Object)"alerta");
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setHeaderText(header);
        alert.setContentText(msj);
        alert.setResizable(true);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)this.stageHolder.getStage());
        ButtonType btnSi = new ButtonType("S\u00ed");
        ButtonType btnNo = new ButtonType("No");
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{btnSi, btnNo});
        Optional result = alert.showAndWait();
        return result.get() == btnSi;
    }

    @FXML
    public void displayAlertWarningConProxy(String msj) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("");
        alert.getDialogPane().getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        alert.getDialogPane().getStyleClass().add((Object)"alerta");
        alert.getDialogPane().setPrefSize((double)StageUtil.WIDTH_ALERT_BIG.intValue(), (double)StageUtil.HEIGHT_ALERT_BIG.intValue());
        alert.setHeaderText(this.msgUtil.getValue("MSG_ALERT_HEADER_WARNING"));
        alert.setContentText(msj);
        alert.setResizable(true);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)this.stageHolder.getStage());
        alert.showAndWait();
    }

    @FXML
    public void displayAlertInfo(String msj) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("");
        alert.getDialogPane().getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        alert.getDialogPane().getStyleClass().add((Object)"alerta");
        alert.getDialogPane().setPrefSize((double)StageUtil.WIDTH_ALERT.intValue(), (double)StageUtil.HEIGHT_ALERT.intValue());
        alert.setHeaderText(this.msgUtil.getValue("MSG_ALERT_HEADER_INFO"));
        alert.setContentText(msj);
        alert.setResizable(true);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)this.stageHolder.getStage());
        alert.showAndWait();
    }
}

