/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties.data;

import java.util.List;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataObjectStructureVerifier;
import xades4j.properties.data.PropertyDataStructureException;
import xades4j.utils.ObjectUtils;

class BaseXAdESTimeStampDataStructureVerifier
implements PropertyDataObjectStructureVerifier {
    private final String propName;

    public BaseXAdESTimeStampDataStructureVerifier(String propName) {
        this.propName = propName;
    }

    @Override
    public void verifyStructure(PropertyDataObject propData) throws PropertyDataStructureException {
        BaseXAdESTimeStampData tsData = (BaseXAdESTimeStampData)propData;
        if (null == tsData.getCanonicalizationAlgorithm()) {
            throw new PropertyDataStructureException("canonicalization algorithm not specified", this.propName);
        }
        List<byte[]> tsTokens = tsData.getTimeStampTokens();
        if (tsTokens.isEmpty()) {
            throw new PropertyDataStructureException("no time stamp tokens", this.propName);
        }
        if (ObjectUtils.anyNull(tsTokens)) {
            throw new PropertyDataStructureException("null time stamp token", this.propName);
        }
    }
}

