/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties.data;

import java.util.Collection;
import xades4j.properties.data.CRLRef;
import xades4j.properties.data.CompleteRevocationRefsData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataObjectStructureVerifier;
import xades4j.properties.data.PropertyDataStructureException;
import xades4j.utils.ObjectUtils;

class CompleteRevocationRefsDataStructureVerifier
implements PropertyDataObjectStructureVerifier {
    CompleteRevocationRefsDataStructureVerifier() {
    }

    @Override
    public void verifyStructure(PropertyDataObject propData) throws PropertyDataStructureException {
        Collection<CRLRef> crlRefs = ((CompleteRevocationRefsData)propData).getCrlRefs();
        if (null == crlRefs || crlRefs.isEmpty()) {
            throw new PropertyDataStructureException("empty CRL reference list", "CompleteRevocationRefs");
        }
        for (CRLRef r : crlRefs) {
            if (null == r) {
                throw new PropertyDataStructureException("null CRL reference", "CompleteRevocationRefs");
            }
            if (!ObjectUtils.anyNull(r.issuerDN, r.digestAlgUri, r.digestValue, r.issueTime)) continue;
            throw new PropertyDataStructureException("empty data on one or more CRL references", "CompleteRevocationRefs");
        }
    }
}

