/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class FileSystemDirectoryCertStore {
    private static final String[] DEFAULT_CERT_FILE_EXT = new String[]{"cer", "crt"};
    private static final String[] DEFAULT_CRL_FILE_EXT = new String[]{"crl"};
    private final CertStore content;

    public FileSystemDirectoryCertStore(String dirPath) throws CertificateException, CRLException {
        this(dirPath, DEFAULT_CERT_FILE_EXT, DEFAULT_CRL_FILE_EXT);
    }

    public FileSystemDirectoryCertStore(String dirPath, String[] certsFilesExts, String[] crlsFilesExts) throws CertificateException, CRLException {
        this(dirPath, certsFilesExts, crlsFilesExts, CertificateFactory.getInstance("X.509"));
    }

    public FileSystemDirectoryCertStore(String dirPath, String certFactoryProvider) throws CertificateException, CRLException, NoSuchProviderException {
        this(dirPath, DEFAULT_CERT_FILE_EXT, DEFAULT_CRL_FILE_EXT, certFactoryProvider);
    }

    public FileSystemDirectoryCertStore(String dirPath, String[] certsFilesExts, String[] crlsFilesExts, String certFactoryProvider) throws CertificateException, CRLException, NoSuchProviderException {
        this(dirPath, certsFilesExts, crlsFilesExts, CertificateFactory.getInstance("X.509", certFactoryProvider));
    }

    protected FileSystemDirectoryCertStore(String dirPath, String[] certsFilesExts, String[] crlsFilesExts, CertificateFactory cf) throws CertificateException, CRLException {
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path doesn't exist or doesn't refer a directory");
        }
        ArrayList contentList = new ArrayList();
        this.transverseDirToFindContent(dir, contentList, certsFilesExts, crlsFilesExts, cf);
        try {
            this.content = CertStore.getInstance("Collection", new CollectionCertStoreParameters(contentList));
            return;
        }
        catch (InvalidAlgorithmParameterException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        throw new CertificateException("Error getting Collection CertStore");
    }

    private void transverseDirToFindContent(File dir, Collection contentList, String[] certsFilesExts, String[] crlsFilesExts, CertificateFactory cf) throws CertificateException, CRLException {
        File[] dirContents = dir.listFiles();
        for (int i = 0; i < dirContents.length; ++i) {
            File f = dirContents[i];
            if (f.isDirectory()) {
                this.transverseDirToFindContent(f, contentList, certsFilesExts, crlsFilesExts, cf);
                continue;
            }
            if (!f.isFile()) continue;
            try {
                if (this.hasExt(f, certsFilesExts)) {
                    contentList.add((X509Certificate)cf.generateCertificate(new FileInputStream(f)));
                    continue;
                }
                if (!this.hasExt(f, crlsFilesExts)) continue;
                contentList.add((X509CRL)cf.generateCRL(new FileInputStream(f)));
                continue;
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
    }

    private boolean hasExt(File f, String[] filesExts) {
        for (int j = 0; j < filesExts.length; ++j) {
            if (!f.getName().endsWith('.' + filesExts[j])) continue;
            return true;
        }
        return false;
    }

    public CertStore getStore() {
        return this.content;
    }
}

