/*
 * Decompiled with CFR 0.152.
 */
package xades4j.utils;

import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.algorithms.Algorithm;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.DOMHelper;
import xades4j.utils.StreamUtils;
import xades4j.utils.TimeStampDigestInput;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class TimeStampDigestInputImpl
implements TimeStampDigestInput {
    private final Algorithm c14n;
    private final AlgorithmsParametersMarshallingProvider parametersMarshallingProvider;
    private final ByteArrayOutputStream digestInput;

    TimeStampDigestInputImpl(Algorithm c14n, AlgorithmsParametersMarshallingProvider parametersMarshallingProvider) {
        this.c14n = c14n;
        this.parametersMarshallingProvider = parametersMarshallingProvider;
        this.digestInput = new ByteArrayOutputStream();
    }

    @Override
    public void addReference(Reference r) throws CannotAddDataToDigestInputException {
        if (null == r) {
            throw new NullPointerException();
        }
        try {
            XMLSignatureInput refData = r.getContentsAfterTransformation();
            this.addToDigestInput(refData, r.getDocument());
        }
        catch (XMLSignatureException ex) {
            throw new CannotAddDataToDigestInputException(ex);
        }
    }

    @Override
    public void addNode(Node n) throws CannotAddDataToDigestInputException {
        if (null == n) {
            throw new NullPointerException();
        }
        this.addToDigestInput(new XMLSignatureInput(n), n.getOwnerDocument());
    }

    private void addToDigestInput(XMLSignatureInput refData, Document doc) throws CannotAddDataToDigestInputException {
        try {
            if (refData.isNodeSet() || refData.isElement()) {
                List<Node> c14nParams = this.parametersMarshallingProvider.marshalParameters(this.c14n, doc);
                Transform t = null == c14nParams ? new Transform(doc, this.c14n.getUri()) : new Transform(doc, this.c14n.getUri(), DOMHelper.nodeList(c14nParams));
                refData = t.performTransform(refData);
            }
            if (refData.isByteArray()) {
                this.digestInput.write(refData.getBytes());
            } else if (refData.isOctetStream()) {
                StreamUtils.readWrite(refData.getOctetStream(), this.digestInput);
            }
        }
        catch (Exception ex) {
            throw new CannotAddDataToDigestInputException(ex);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.digestInput.toByteArray();
    }
}

