/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.XAdES4jException;
import xades4j.properties.CounterSignatureProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.GenericDOMData;
import xades4j.utils.DOMHelper;
import xades4j.verification.CounterSignatureSigValueRefException;
import xades4j.verification.CounterSignatureVerificationException;
import xades4j.verification.CounterSignatureXadesVerificationException;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.XAdESVerificationResult;
import xades4j.verification.XadesVerifier;

class CounterSignatureVerifier
implements QualifyingPropertyVerifier<GenericDOMData> {
    private final XadesVerifier verifier;

    @Inject
    CounterSignatureVerifier(XadesVerifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public QualifyingProperty verify(GenericDOMData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
        XAdESVerificationResult res;
        try {
            Element sigElem = DOMHelper.getFirstChildElement(propData.getPropertyElement());
            res = this.verifier.verify(sigElem, null);
        }
        catch (XAdES4jException ex) {
            throw new CounterSignatureXadesVerificationException(ex);
        }
        Node targetSigValueElem = ctx.getSignature().getElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0);
        try {
            SignedInfo si = res.getXmlSignature().getSignedInfo();
            for (int i = 0; i < si.getLength(); ++i) {
                Reference r = si.item(i);
                if (r.getContentsAfterTransformation().getSubNode() != targetSigValueElem) continue;
                return new CounterSignatureProperty(res);
            }
            throw new CounterSignatureSigValueRefException();
        }
        catch (XMLSecurityException e) {
            throw new CounterSignatureVerificationException(e);
        }
    }
}

