/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.text.DateFormat;
import java.util.Date;
import xades4j.verification.InvalidPropertyException;

public class SigningTimeVerificationException
extends InvalidPropertyException {
    private final Date sigTime;
    private final Date maximumExpectedTime;

    public SigningTimeVerificationException(Date sigTime, Date maximumExpectedTime) {
        this.sigTime = sigTime;
        this.maximumExpectedTime = maximumExpectedTime;
    }

    public Date getSigTime() {
        return this.sigTime;
    }

    public Date getMaximumExpectedTime() {
        return this.maximumExpectedTime;
    }

    @Override
    protected String getVerificationMessage() {
        DateFormat df = DateFormat.getDateTimeInstance();
        return String.format("Expected a signature time before %s but actual signature time is %s", df.format(this.maximumExpectedTime), df.format(this.sigTime));
    }

    @Override
    public String getPropertyName() {
        return "SigningTime";
    }
}

