/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import xades4j.UnsupportedAlgorithmException;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.providers.TimeStampTokenDigestException;
import xades4j.providers.TimeStampTokenSignatureException;
import xades4j.providers.TimeStampTokenStructureException;
import xades4j.providers.TimeStampTokenVerificationException;
import xades4j.providers.TimeStampVerificationProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.TimeStampDigestInputException;
import xades4j.verification.TimeStampDigestMismatchException;
import xades4j.verification.TimeStampInvalidSignatureException;
import xades4j.verification.TimeStampInvalidTokenException;
import xades4j.verification.TimeStampVerificationException;

abstract class TimeStampVerifierBase<TData extends BaseXAdESTimeStampData>
implements QualifyingPropertyVerifier<TData> {
    private final TimeStampVerificationProvider tsVerifier;
    private final TimeStampDigestInputFactory tsInputFactory;
    private final String propName;

    public TimeStampVerifierBase(TimeStampVerificationProvider tsVerifier, TimeStampDigestInputFactory tsInputFactory, String propName) {
        this.tsVerifier = tsVerifier;
        this.tsInputFactory = tsInputFactory;
        this.propName = propName;
    }

    @Override
    public final QualifyingProperty verify(TData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
        try {
            TimeStampDigestInput digestInput = this.tsInputFactory.newTimeStampDigestInput(((BaseXAdESTimeStampData)propData).getCanonicalizationAlgorithm());
            QualifyingProperty prop = this.addPropSpecificTimeStampInputAndCreateProperty(propData, digestInput, ctx);
            byte[] data = digestInput.getBytes();
            List<byte[]> tokens = ((BaseXAdESTimeStampData)propData).getTimeStampTokens();
            Date ts = null;
            for (byte[] tkn : tokens) {
                ts = this.tsVerifier.verifyToken(tkn, data);
            }
            Method setTimeMethod = prop.getClass().getMethod("setTime", Date.class);
            setTimeMethod.invoke((Object)prop, ts);
            return prop;
        }
        catch (UnsupportedAlgorithmException ex) {
            throw TimeStampVerifierBase.getEx(ex, this.propName);
        }
        catch (CannotAddDataToDigestInputException ex) {
            throw new TimeStampDigestInputException(this.propName, ex);
        }
        catch (TimeStampTokenVerificationException ex) {
            throw TimeStampVerifierBase.getEx(ex, this.propName);
        }
        catch (Exception ex) {
            throw TimeStampVerifierBase.getEx(ex, this.propName);
        }
    }

    protected abstract QualifyingProperty addPropSpecificTimeStampInputAndCreateProperty(TData var1, TimeStampDigestInput var2, QualifyingPropertyVerificationContext var3) throws CannotAddDataToDigestInputException, TimeStampVerificationException;

    private static TimeStampVerificationException getEx(final Exception ex, String propName) {
        if (ex instanceof TimeStampTokenDigestException) {
            return new TimeStampDigestMismatchException(propName);
        }
        if (ex instanceof TimeStampTokenSignatureException) {
            return new TimeStampInvalidSignatureException(propName, ex);
        }
        if (ex instanceof TimeStampTokenStructureException) {
            return new TimeStampInvalidTokenException(propName, ex);
        }
        return new TimeStampVerificationException(propName, ex){

            @Override
            protected String getVerificationMessage() {
                return ex.getMessage();
            }
        };
    }
}

