/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling;

import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.w3c.dom.Document;
import xades4j.properties.data.CRLRef;
import xades4j.properties.data.CompleteRevocationRefsData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.xml.bind.xades.XmlCRLIdentifierType;
import xades4j.xml.bind.xades.XmlCRLRefType;
import xades4j.xml.bind.xades.XmlCRLRefsType;
import xades4j.xml.bind.xades.XmlCompleteRevocationRefsType;
import xades4j.xml.bind.xades.XmlDigestAlgAndValueType;
import xades4j.xml.bind.xades.XmlUnsignedPropertiesType;
import xades4j.xml.bind.xmldsig.XmlDigestMethodType;
import xades4j.xml.marshalling.UnsignedPropertyDataToXmlConverter;

class ToXmlCompleteRevocRefsConverter
implements UnsignedPropertyDataToXmlConverter {
    ToXmlCompleteRevocRefsConverter() {
    }

    @Override
    public void convertIntoObjectTree(PropertyDataObject propData, XmlUnsignedPropertiesType xmlProps, Document doc) {
        CompleteRevocationRefsData complRevocRefsData = (CompleteRevocationRefsData)propData;
        XmlCRLRefsType xmlCRLRefs = new XmlCRLRefsType();
        List<XmlCRLRefType> xmlCRLRefsList = xmlCRLRefs.getCRLRef();
        try {
            for (CRLRef crlRef : complRevocRefsData.getCrlRefs()) {
                XmlCRLIdentifierType xmlCrlId = new XmlCRLIdentifierType();
                xmlCrlId.setIssueTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(crlRef.issueTime));
                xmlCrlId.setIssuer(crlRef.issuerDN);
                xmlCrlId.setNumber(crlRef.serialNumber);
                XmlDigestAlgAndValueType xmlDigest = new XmlDigestAlgAndValueType();
                XmlDigestMethodType xmlDigestMethod = new XmlDigestMethodType();
                xmlDigestMethod.setAlgorithm(crlRef.digestAlgUri);
                xmlDigest.setDigestValue(crlRef.digestValue);
                xmlDigest.setDigestMethod(xmlDigestMethod);
                XmlCRLRefType xmlCrlRef = new XmlCRLRefType();
                xmlCrlRef.setCRLIdentifier(xmlCrlId);
                xmlCrlRef.setDigestAlgAndValue(xmlDigest);
                xmlCRLRefsList.add(xmlCrlRef);
            }
        }
        catch (DatatypeConfigurationException ex) {
            throw new UnsupportedOperationException(ex.getMessage(), ex);
        }
        XmlCompleteRevocationRefsType xmlComplRevocRefs = new XmlCompleteRevocationRefsType();
        xmlComplRevocRefs.setCRLRefs(xmlCRLRefs);
        xmlProps.getUnsignedSignatureProperties().setCompleteRevocationRefs(xmlComplRevocRefs);
    }
}

