/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.xml.marshalling.algorithms.AlgorithmParametersMarshaller;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

final class AlgorithmsParametersMarshallingProviderImpl
implements AlgorithmsParametersMarshallingProvider {
    private final Injector injector;

    @Inject
    public AlgorithmsParametersMarshallingProviderImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public List<Node> marshalParameters(Algorithm alg, Document doc) throws UnsupportedAlgorithmException {
        AlgorithmParametersMarshaller marshaller;
        try {
            ParameterizedType pt = Types.newParameterizedType(AlgorithmParametersMarshaller.class, (Type[])new Type[]{alg.getClass()});
            marshaller = (AlgorithmParametersMarshaller)this.injector.getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)pt)));
        }
        catch (RuntimeException ex) {
            throw new UnsupportedAlgorithmException("AlgorithmParametersMarshaller not available", alg.getUri(), ex);
        }
        List<Node> params = marshaller.marshalParameters(alg, doc);
        if (params != null && params.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter marshaller returned empty parameter list for algorithm %s", alg.getUri()));
        }
        return params;
    }
}

