/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import xades4j.properties.ObjectIdentifier;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdType;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdentifierType;
import xades4j.xml.bind.xades.XmlSignedSignaturePropertiesType;
import xades4j.xml.unmarshalling.FromXmlUtils;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.SignedSigPropFromXmlConv;

class FromXmlSignaturePolicyConverter
implements SignedSigPropFromXmlConv {
    FromXmlSignaturePolicyConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlSignedSignaturePropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        XmlSignaturePolicyIdentifierType xmlSigPolicy = xmlProps.getSignaturePolicyIdentifier();
        if (null == xmlSigPolicy) {
            return;
        }
        if (xmlSigPolicy.getSignaturePolicyImplied() != null) {
            propertyDataCollector.setSignaturePolicy(new SignaturePolicyData());
            return;
        }
        XmlSignaturePolicyIdType xmlPolicyId = xmlSigPolicy.getSignaturePolicyId();
        if (xmlPolicyId.getTransforms() != null) {
            throw new PropertyUnmarshalException("Signature policy transforms are not supported", "SignaturePolicyIdentifier");
        }
        ObjectIdentifier policyId = FromXmlUtils.getObjectIdentifier(xmlPolicyId.getSigPolicyId());
        propertyDataCollector.setSignaturePolicy(new SignaturePolicyData(policyId, xmlPolicyId.getSigPolicyHash().getDigestMethod().getAlgorithm(), xmlPolicyId.getSigPolicyHash().getDigestValue()));
    }
}

