/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy.facturae;

import es.mityc.firmaJava.libreria.xades.elementos.xades.DigestAlgAndValueType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyHash;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.xml.xades.policy.facturae.ConfigFacturaeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFacturae {
    private static final Log LOG = LogFactory.getLog(ConfigFacturae.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibPolicy");
    private static final String STRING_POINT = ".";
    private static final String STRING_EMPTY = "";
    private URI policyIdXades;
    private String policyIdValidador;
    private String policyDescription;
    private ArrayList<DigestAlgAndValueType> huellas;
    private int policyWriterId;

    public ConfigFacturae(Properties props, String prefix) throws ConfigFacturaeException {
        String prep;
        block13: {
            this.policyIdXades = null;
            this.policyIdValidador = null;
            this.policyDescription = null;
            this.huellas = null;
            this.policyWriterId = -1;
            prep = STRING_EMPTY;
            if (prefix != null && !STRING_EMPTY.equals(prefix.trim())) {
                prep = prefix + STRING_POINT;
            }
            try {
                String policyIdXadesStr = props.getProperty(prep + "policy.id");
                this.policyIdValidador = props.getProperty(prep + "policy.idValidator");
                if (policyIdXadesStr == null || this.policyIdValidador == null) {
                    LOG.fatal((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.1"));
                    throw new ConfigFacturaeException(I18N.getLocalMessage("i18n.mityc.policy.facturae.2"));
                }
                this.policyIdXades = new URI(policyIdXadesStr);
            }
            catch (URISyntaxException ex) {
                LOG.fatal((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.3"));
                throw new ConfigFacturaeException(I18N.getLocalMessage("i18n.mityc.policy.facturae.2"), ex);
            }
            try {
                this.policyDescription = props.getProperty(prep + "policy.idValidator");
            }
            catch (MissingResourceException ex) {
                if (!LOG.isTraceEnabled()) break block13;
                LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.4", new Object[]{prep}));
            }
        }
        this.huellas = new ArrayList();
        int i = 0;
        while (true) {
            String hashId = props.getProperty(prep + "policy.digest.id." + i);
            String hashValue = props.getProperty(prep + "policy.digest.value." + i);
            if (hashId == null || hashValue == null) break;
            this.huellas.add((DigestAlgAndValueType)new SigPolicyHash(null, hashId, hashValue));
            ++i;
        }
        try {
            String policyWriterIdStr = props.getProperty(prep + "policy.writer.digest");
            if (policyWriterIdStr == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.6", new Object[]{prep}));
                }
            } else {
                this.policyWriterId = Integer.parseInt(policyWriterIdStr);
                if (this.policyWriterId >= this.huellas.size()) {
                    this.policyWriterId = -1;
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.5"));
                }
            }
        }
        catch (NumberFormatException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.policy.facturae.5"), (Throwable)ex);
        }
    }

    public URI getPolicyIdXades() {
        return this.policyIdXades;
    }

    public String getPolicyIdValidador() {
        return this.policyIdValidador;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public int getPolicyWriterId() {
        return this.policyWriterId;
    }

    public ArrayList<DigestAlgAndValueType> getHuellas() {
        return this.huellas;
    }
}

